VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form EarthResistFullGraph 
   Caption         =   "Earth Resistivity and Magnetometer Full Graph"
   ClientHeight    =   7590
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   11880
   Icon            =   "EarthResistFullGraph.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   7590
   ScaleWidth      =   11880
   StartUpPosition =   1  'CenterOwner
   Begin VB.CheckBox Resist 
      Caption         =   "Current"
      Height          =   195
      Left            =   120
      TabIndex        =   23
      ToolTipText     =   "Multiplies sample voltage by current value across TX probes"
      Top             =   6480
      Width           =   855
   End
   Begin VB.TextBox Text1 
      Height          =   285
      Left            =   2520
      TabIndex        =   21
      Text            =   "0"
      ToolTipText     =   "Subtracts this value before implementing slider correction values. Press Enter to activate new value"
      Top             =   0
      Width           =   975
   End
   Begin VB.CommandButton RefreshIt 
      BackColor       =   &H00FFFF00&
      Caption         =   "Refresh"
      Default         =   -1  'True
      Height          =   375
      Left            =   120
      Style           =   1  'Graphical
      TabIndex        =   7
      ToolTipText     =   "Click to implement correction changes"
      Top             =   1080
      Width           =   975
   End
   Begin VB.CommandButton Fullgrid 
      BackColor       =   &H0000FF00&
      Caption         =   "Full Grid"
      Height          =   375
      Left            =   120
      Style           =   1  'Graphical
      TabIndex        =   18
      ToolTipText     =   "Calls up Full Grid display"
      Top             =   720
      Width           =   975
   End
   Begin VB.CommandButton Main 
      BackColor       =   &H0000FFFF&
      Caption         =   "Main"
      Height          =   375
      Left            =   120
      Style           =   1  'Graphical
      TabIndex        =   0
      ToolTipText     =   "Return to main page"
      Top             =   360
      Width           =   975
   End
   Begin VB.CheckBox Rotate 
      Caption         =   "Vertical"
      Height          =   255
      Left            =   120
      TabIndex        =   16
      ToolTipText     =   "Horizontal contours if unticked, vertical if ticked"
      Top             =   5480
      Width           =   975
   End
   Begin MSComctlLib.Slider Zoomer 
      Height          =   375
      Left            =   0
      TabIndex        =   15
      ToolTipText     =   "Enlarges view by zoom value/2+0.5. Min=1 Max=5.5"
      Top             =   0
      Width           =   1095
      _ExtentX        =   1931
      _ExtentY        =   661
      _Version        =   393216
      Min             =   1
      SelStart        =   5
      Value           =   5
   End
   Begin VB.CheckBox Inverter 
      Caption         =   "Invert"
      Height          =   255
      Left            =   120
      TabIndex        =   14
      ToolTipText     =   "When ticked sets high values low and low values high"
      Top             =   5760
      Value           =   1  'Checked
      Width           =   1095
   End
   Begin VB.CommandButton Sync 
      BackColor       =   &H00FFFF00&
      Caption         =   "Sync ?"
      Height          =   375
      Left            =   240
      Style           =   1  'Graphical
      TabIndex        =   13
      ToolTipText     =   "Shows col/row last download sync corrections - click on/off"
      Top             =   6720
      Visible         =   0   'False
      Width           =   735
   End
   Begin VB.ListBox List1 
      Height          =   3375
      Left            =   0
      TabIndex        =   12
      Top             =   2040
      Visible         =   0   'False
      Width           =   1215
   End
   Begin VB.CommandButton Quit 
      BackColor       =   &H0000FF00&
      Caption         =   "Quit"
      Height          =   375
      Left            =   240
      Style           =   1  'Graphical
      TabIndex        =   6
      ToolTipText     =   "Final exit from program"
      Top             =   7080
      Visible         =   0   'False
      Width           =   735
   End
   Begin VB.CheckBox BlanksFill 
      Caption         =   "Fill blanks"
      Height          =   375
      Left            =   120
      TabIndex        =   5
      ToolTipText     =   "When ticked draws zero value lines on graph"
      Top             =   6000
      Width           =   975
   End
   Begin MSComctlLib.Slider Slider2 
      Height          =   3495
      Left            =   600
      TabIndex        =   4
      ToolTipText     =   "Add/Subtract from value after multiplying of dividing"
      Top             =   2040
      Width           =   375
      _ExtentX        =   661
      _ExtentY        =   6165
      _Version        =   393216
      Orientation     =   1
      Max             =   1000
      TickStyle       =   1
      TickFrequency   =   100
   End
   Begin MSComctlLib.Slider Slider3 
      Height          =   3495
      Left            =   120
      TabIndex        =   3
      ToolTipText     =   "Value multiply/divide"
      Top             =   2040
      Width           =   375
      _ExtentX        =   661
      _ExtentY        =   6165
      _Version        =   393216
      Orientation     =   1
      Min             =   1
      Max             =   100
      SelStart        =   1
      TickStyle       =   1
      TickFrequency   =   10
      Value           =   1
   End
   Begin MSComctlLib.Slider Slider1 
      Height          =   6810
      Left            =   1080
      TabIndex        =   8
      ToolTipText     =   "Row Coordinate & sets centre origin for zoom"
      Top             =   720
      Width           =   345
      _ExtentX        =   609
      _ExtentY        =   12012
      _Version        =   393216
      Orientation     =   1
      SmallChange     =   10
      Max             =   127
      TickStyle       =   3
   End
   Begin MSComctlLib.Slider Slider4 
      Height          =   375
      Left            =   1395
      TabIndex        =   9
      ToolTipText     =   "Column Coordinate & sets centre origin for zoom"
      Top             =   360
      Width           =   10335
      _ExtentX        =   18230
      _ExtentY        =   661
      _Version        =   393216
      Max             =   127
      TickStyle       =   3
   End
   Begin VB.Label Label5 
      Alignment       =   1  'Right Justify
      Caption         =   "Pre-subtract"
      Height          =   255
      Left            =   1640
      TabIndex        =   22
      ToolTipText     =   "Subtracts this value before implementing slider correction values. Press Enter to activate new value"
      Top             =   45
      Width           =   855
   End
   Begin VB.Label Label2 
      BackColor       =   &H00C0C0C0&
      Caption         =   "New value"
      Height          =   255
      Left            =   6960
      TabIndex        =   20
      Top             =   45
      Width           =   3375
   End
   Begin VB.Label Label1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Orig value"
      Height          =   255
      Left            =   3600
      TabIndex        =   19
      Top             =   45
      Width           =   3375
   End
   Begin VB.Label Label6 
      Alignment       =   2  'Center
      BackColor       =   &H000000FF&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "WAIT"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   405
      Left            =   120
      TabIndex        =   17
      Top             =   1560
      Visible         =   0   'False
      Width           =   975
   End
   Begin VB.Label Label4 
      Alignment       =   2  'Center
      Caption         =   "0"
      Height          =   255
      Left            =   720
      TabIndex        =   11
      ToolTipText     =   "As on main page"
      Top             =   1800
      Width           =   375
   End
   Begin VB.Label Label3 
      Alignment       =   2  'Center
      Caption         =   "1"
      Height          =   255
      Left            =   240
      TabIndex        =   10
      ToolTipText     =   "As on main page"
      Top             =   1800
      Width           =   255
   End
   Begin VB.Label AddGraph 
      Alignment       =   2  'Center
      Caption         =   "minus"
      ForeColor       =   &H00C00000&
      Height          =   255
      Left            =   600
      TabIndex        =   2
      ToolTipText     =   "As on main page"
      Top             =   1560
      Width           =   495
   End
   Begin VB.Label MultiplyGraph 
      Alignment       =   2  'Center
      Caption         =   "/"
      ForeColor       =   &H00C00000&
      Height          =   255
      Left            =   240
      TabIndex        =   1
      ToolTipText     =   "As on main page"
      Top             =   1560
      Width           =   255
   End
   Begin VB.Shape Shape1 
      BorderWidth     =   2
      Height          =   6495
      Left            =   1560
      Top             =   840
      Width           =   10095
   End
End
Attribute VB_Name = "EarthResistFullGraph"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Earth Resistivity full graph 14MAR03

Public Sub PlotIt_Click()
If DownloadFlag2 = 1 Then Exit Sub
Zoom = Zoomer.Value / 2 + 0.5
Shape1.Refresh
Label6.Visible = True: Label6.Refresh
Screen.MousePointer = vbHourglass
B = 0: F = 127: H = Shape1.Height / 140: W = Shape1.Width / 129: down = 520
W = W * Zoom
H = H * Zoom

X = Shape1.Left + 8

If Inverter.Value = 0 Then
For A = 0 To 127: Previous(A) = (H * A) + Shape1.Top + H + down:
If Previous(A) > (Shape1.Top + Shape1.Height - 300) Then Previous(A) = Shape1.Top + Shape1.Height - 300
Next
Else
For A = 0 To 127: Previous(A) = (H * A) + Shape1.Top + H:
If Previous(A) > (Shape1.Top + Shape1.Height - 300) Then Previous(A) = Shape1.Top + Shape1.Height - 300
Next
End If

span = Int(128 / Zoom)
halfspan = Int(span / 2)

Horizontal0 = Slider4.Value - halfspan
If Horizontal0 < 0 Then Horizontal0 = 0
Horizontal1 = Slider4.Value + halfspan
If Horizontal1 - Horizontal0 < span Then Horizontal1 = Horizontal0 + span
If Horizontal1 > 127 Then Horizontal1 = 127
Slider4.Max = Horizontal1
Slider4.Min = Horizontal0

Vertical0 = Slider1.Value - halfspan
If Vertical0 < 0 Then Vertical0 = 0
Vertical1 = Slider1.Value + halfspan
If Vertical1 - Vertical0 < span Then Vertical1 = Vertical0 + span
If Vertical1 > 127 Then Vertical1 = 127
Slider1.Max = Vertical1
Slider1.Min = Vertical0

Min = 65536: Max = 0: Min2 = 65536: Max2 = 0

If Rotate.Value = 1 Then GoTo PlotitVertical

For A = Horizontal0 To Horizontal1: D = 0: Y1 = Shape1.Top + 8
For C = Vertical0 To Vertical1: V = FileSamples(0, A, C): ' * Zoom
If V = 0 Then V1 = 0: GoTo 100

If V < Min Then Min = V
If V > Max Then Max = V

If Resist.Value = 1 Then V = V * FileSamples(1, A, C)

V = V - Val(Text1.Text)
If V < 0 Then V = 0

 If MultiplyGraph.Caption <> "X" Then
  V1 = Int(V / Slider3.Value)
  Else
  V1 = Int(V * Slider3.Value)
 End If

 If AddGraph.Caption <> "minus" Then
  V1 = V1 + Slider2.Value
  Else
  V1 = V1 - Slider2.Value
 End If

 If V1 < 0 Then V1 = 0: GoTo 100

If V1 < Min2 Then Min2 = V1
If V1 > Max2 Then Max2 = V1

100:
V1 = V1 * Zoom
If BlanksFill.Value = 0 And V = 0 Then GoTo 110

 If Inverter.Value = 0 Then
 Y = (H * D) - V1 + Shape1.Top + down + H
 Else
 Y = (H * D) + V1 + Shape1.Top + H
 End If
  
 If Y < Shape1.Top + 8 Then Y = Shape1.Top + 8
 If Y > (Shape1.Top + Shape1.Height - 50) Then Y = Shape1.Top + Shape1.Height - 50
X1 = X + W: If X1 > Shape1.Left - 50 + Shape1.Width Then X1 = Shape1.Left + Shape1.Width - 50
Line (X, Previous(D))-(X1, Y), Col(3, C And 7)
 Previous(D) = Y
110: D = D + 1: Next: X = X + W: If X > Shape1.Left - 50 + Shape1.Width Then X = Shape1.Left + Shape1.Width - 50
Next
Label6.Visible = False
Screen.MousePointer = vbDefault
Label1.Caption = "Orig Value Range Min = " & Min & "   Max = " & Max
Label2.Caption = "New Value Range Min = " & Int(Min2) & "  Max = " & Int(Max2)
Text1.SetFocus
Exit Sub

PlotitVertical:

H = Shape1.Height / 128:
W = Shape1.Width / 140:
H = H * Zoom
W = W * Zoom
If Inverter.Value = 0 Then X = Shape1.Left + 800

For A = Horizontal0 To Horizontal1: D = 0: Y1 = Shape1.Top + 8
Previous(D) = X: Y = Y1: X1 = X
For C = Vertical0 To Vertical1: V = FileSamples(0, A, C)
If V = 0 Then V1 = 0: GoTo 201
If Resist.Value = 1 Then V = V * FileSamples(1, A, C)
If V < Min Then Min = V
If V > Max Then Max = V

201:
V = V - Val(Text1.Text)
If V < 0 Then V = 0

 If MultiplyGraph.Caption <> "X" Then
  V1 = Int(V / Slider3.Value)
  Else
  V1 = Int(V * Slider3.Value)
 End If

 If AddGraph.Caption <> "minus" Then
  V1 = V1 + Slider2.Value
  Else
  V1 = V1 - Slider2.Value
 End If

 If V1 < 0 Then V1 = 0: GoTo 202

If V1 < Min2 Then Min2 = V1
If V1 > Max2 Then Max2 = V1
 
202:
V1 = V1 * Zoom
If Inverter.Value = 0 Then
X1 = X - V1
Else
X1 = X + V1
End If

If X1 < Shape1.Left + 8 Then X1 = Shape1.Left + 8
If X1 > Shape1.Left - 50 + Shape1.Width Then X1 = Shape1.Left + Shape1.Width - 50
If BlanksFill.Value = 1 Or V > 0 Then Line (Previous(D), Y)-(X1, Y1), Col(3, A And 7)
D = D + 1
Previous(D) = X1: Y = Y1

Y1 = Y1 + H
If Y1 < Shape1.Top + 8 Then Y1 = Shape1.Top + 8
If Y1 > (Shape1.Top + Shape1.Height) Then Y1 = Shape1.Top + Shape1.Height

Next: X = X + W: If X > Shape1.Left - 50 + Shape1.Width Then X = Shape1.Left + Shape1.Width - 50
Next
Label6.Visible = False
Screen.MousePointer = vbDefault

If Min = 65535 Then Min = 0
If Min2 = 65535 Then Min2 = 0
If Max = 0 Then Min = 0
If Max2 = 0 Then Min2 = 0

Label1.Caption = "Orig Value Range Min = " & Min & "   Max = " & Max
Label2.Caption = "New Value Range Min = " & Int(Min2) & "  Max = " & Int(Max2)

End Sub

Private Sub BlanksFill_Click()
Shape1.Refresh
Call PlotIt_Click
End Sub

Private Sub Form_Unload(Cancel As Integer)
Call Main_Click
End Sub

Private Sub FullGrid_Click()
EarthResistFullGraph.Hide
EarthResFullGrid.Show
Call EarthResFullGrid.PlotIt_Click
End Sub

Private Sub Inverter_Click()
Call PlotIt_Click
End Sub

Private Sub Main_Click()
EarthResistFullGraph.Hide
EarthResist.Show
Call EarthResist.PlotIt_Click
End Sub

Private Sub Option1_Click(Index As Integer)
Shape1.Refresh
Mode2 = Index: Call PlotIt_Click
End Sub

Private Sub Quit_Click()
End
End Sub

Private Sub RefreshIt_Click()
Call PlotIt_Click
End Sub

Private Sub resist_Click()
Call PlotIt_Click
End Sub

Private Sub Rotate_Click()
Call PlotIt_Click
End Sub

Private Sub slider3_change()
If DownloadFlag2 = 1 Then Exit Sub
V = Slider3.Value
Label3.Caption = V
End Sub

Private Sub slider2_change()
If DownloadFlag2 = 1 Then Exit Sub
V = Slider2.Value
Label4.Caption = V
End Sub

Private Sub MultiplyGraph_Click()
Shape1.Refresh
If MultiplyGraph.Caption = "X" Then
MultiplyGraph.Caption = "/"
Else
MultiplyGraph.Caption = "X"
End If
End Sub

Private Sub AddGraph_Click()
Shape1.Refresh
If AddGraph.Caption = "minus" Then
AddGraph.Caption = "add"
Else
AddGraph.Caption = "minus"
End If
End Sub

Private Sub Sync_Click()
If List1.Visible = True Then List1.Visible = False Else List1.Visible = True
End Sub

Private Sub text1_click()
Call PlotIt_Click
End Sub

Private Sub Zoomer_Change()
Zoom = Zoomer.Value / 2 + 0.5
End Sub

